/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.convertidores.BooleanNegativeConverter;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloPaginaAsistente;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.compras.valores.ModeloValoresProveedor;
import ec.gob.sri.dimm.ats.modelo.obj.compras.Proveedor;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PaginaProveedor
extends PaginaAsistente
implements VistaModelo<Proveedor>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private boolean editando;
    private Text txtIdProveedor;
    private ModeloValoresProveedor modeloValores;
    private Proveedor modeloDatos;
    private ComboViewer cvTipoIdProveedor;
    private ComboViewer cvTipoProveedor;
    private Composite cParteRelacionada;
    private Button btnSi;
    private Button btnNo;
    private final Periodo periodo;
    private Combo cmbTipoProveedor;
    private Composite compositeParteRelacionada;
    private Label lblTipoDeProveedor;
    private Label lblRazonSocial;
    private Text txtRazonSocial;

    public PaginaProveedor(boolean editando, Periodo periodo) {
        super(PaginaProveedor.class.getName(), "Detalle Exportaci\u00f3n", "Especifique la informaci\u00f3n correspondiente");
        this.periodo = periodo;
        this.setDescription("Especifique la informaci\u00f3n correspondiente al Proveedor");
        this.setTitle("Proveedor");
        this.editando = editando;
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresProveedor();
        this.modeloValores.inicializar();
    }

    public void setModeloDatos(Proveedor modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public void procesarModeloDatos() {
        String codigoIdentificacion = this.modeloDatos.getTipoIdentificacion();
        ElementoNombreValor tipoIdentificacion = this.modeloValores.obtenerTipoIdentificacion(codigoIdentificacion);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoIdProveedor, (Object)tipoIdentificacion);
        this.cargarInformacionDeTipoDeProveedor(codigoIdentificacion);
        ListenerValidacionModeloPaginaAsistente listener = new ListenerValidacionModeloPaginaAsistente((InformacionValidable)this.modeloDatos, (PaginaAsistente)this);
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void cargarInformacionDeTipoDeProveedor(String codigoIdentificacion) {
        if (this.periodo.isPeridoDeAnexoDesdeEnero2013aFebrero2015() && "P".equals(codigoIdentificacion) || this.periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            String codigoTipoProv = this.modeloDatos.getTipoProveedor();
            ElementoNombreValor tipoProv = this.modeloValores.obtenerTipoProveedor(codigoTipoProv);
            AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoProveedor, (Object)tipoProv);
        } else {
            this.cParteRelacionada.setVisible(false);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblTipoIdProveedor = new Label(container, 0);
        GridData gd_lblTipoIdProveedor = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTipoIdProveedor.horizontalIndent = 3;
        lblTipoIdProveedor.setLayoutData((Object)gd_lblTipoIdProveedor);
        lblTipoIdProveedor.setText("Tipo Id. Proveedor");
        this.cvTipoIdProveedor = new ComboViewer(container, 8);
        this.manejarSeleccionComboTipoIdProveedor();
        Combo combo_1 = this.cvTipoIdProveedor.getCombo();
        GridData gd_combo_1 = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo_1.widthHint = 300;
        combo_1.setLayoutData((Object)gd_combo_1);
        Label lblNIdentificacionProveedor = new Label(container, 0);
        GridData gd_lblNIdentificacionProveedor = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblNIdentificacionProveedor.horizontalIndent = 3;
        gd_lblNIdentificacionProveedor.widthHint = 155;
        lblNIdentificacionProveedor.setLayoutData((Object)gd_lblNIdentificacionProveedor);
        lblNIdentificacionProveedor.setText("N\u00b0 Identificaci\u00f3n Proveedor");
        this.txtIdProveedor = new Text(container, 2048);
        this.txtIdProveedor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaProveedor.this.txtIdProveedor.selectAll();
            }
        });
        this.txtIdProveedor.setTextLimit(13);
        GridData gd_txtIdProveedor = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtIdProveedor.widthHint = 100;
        this.txtIdProveedor.setLayoutData((Object)gd_txtIdProveedor);
        this.cParteRelacionada = new Composite(container, 0);
        GridData gd_cParteRelacionada = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_cParteRelacionada.heightHint = 93;
        this.cParteRelacionada.setLayoutData((Object)gd_cParteRelacionada);
        GridLayout gl_cParteRelacionada = new GridLayout(2, false);
        gl_cParteRelacionada.marginWidth = 0;
        this.cParteRelacionada.setLayout((Layout)gl_cParteRelacionada);
        Label lblEsParteRelacionada = new Label(this.cParteRelacionada, 0);
        lblEsParteRelacionada.setText("Es parte relacionada");
        this.compositeParteRelacionada = new Composite(this.cParteRelacionada, 0);
        this.compositeParteRelacionada.setLayout((Layout)new GridLayout(2, false));
        this.btnSi = new Button(this.compositeParteRelacionada, 16);
        this.btnSi.setText("SI");
        this.btnNo = new Button(this.compositeParteRelacionada, 16);
        this.btnNo.setText("NO");
        this.lblTipoDeProveedor = new Label(this.cParteRelacionada, 0);
        GridData gd_lblTipoDeProveedor = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTipoDeProveedor.widthHint = 157;
        this.lblTipoDeProveedor.setLayoutData((Object)gd_lblTipoDeProveedor);
        this.lblTipoDeProveedor.setText("Tipo de Proveedor");
        this.cvTipoProveedor = new ComboViewer(this.cParteRelacionada, 8);
        this.cvTipoProveedor.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoProveedor = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoProveedor != null) {
                    PaginaProveedor.this.modeloDatos.setTipoProveedor((String)tipoProveedor.getValor());
                    PaginaProveedor.this.modeloDatos.setDescripcionTipoProveedor(tipoProveedor.getNombre());
                }
            }
        });
        this.cmbTipoProveedor = this.cvTipoProveedor.getCombo();
        GridData gd_cmbTipoProveedor = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_cmbTipoProveedor.widthHint = 200;
        this.cmbTipoProveedor.setLayoutData((Object)gd_cmbTipoProveedor);
        this.lblRazonSocial = new Label(this.cParteRelacionada, 0);
        GridData gd_lblRazonSocial = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblRazonSocial.heightHint = 26;
        this.lblRazonSocial.setLayoutData((Object)gd_lblRazonSocial);
        this.lblRazonSocial.setText("Raz\u00f3n Social");
        this.txtRazonSocial = new Text(this.cParteRelacionada, 2048);
        this.txtRazonSocial.setTextLimit(500);
        this.txtRazonSocial.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaProveedor.this.txtRazonSocial.selectAll();
            }
        });
        this.txtRazonSocial.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
            }
        });
        GridData gd_txtRazonSocial = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtRazonSocial.widthHint = 220;
        this.txtRazonSocial.setLayoutData((Object)gd_txtRazonSocial);
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
    }

    public void manejarSeleccionComboTipoIdProveedor() {
        this.cvTipoIdProveedor.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ElementoNombreValor tipoID = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (tipoID != null) {
                    PaginaProveedor.this.renderizarParteRelacionadaEnBaseAlPeriodo((ElementoNombreValor<String>)tipoID);
                    PaginaProveedor.this.modeloDatos.setTipoIdentificacion((String)tipoID.getValor());
                    PaginaProveedor.this.modeloDatos.setDescripcionTipoIdentificacion(tipoID.getNombre());
                }
            }
        });
    }

    private void renderizarParteRelacionadaEnBaseAlPeriodo(ElementoNombreValor<String> tipoID) {
        boolean esPasaporte = "P".equals(tipoID.getValor());
        this.renderizarParteRelacionadaParaAnexosEnRangoDe2013aMarzo2015(esPasaporte);
        this.renderizarParteRelacionadaDesdeMarzo2015(esPasaporte);
        this.renderizarRazonSocialParaAnexosDesdeMayo2016(esPasaporte);
    }

    private void renderizarParteRelacionadaDesdeMarzo2015(boolean esPasaporte) {
        if (this.periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            this.cParteRelacionada.setVisible(true);
            if (!esPasaporte) {
                this.modeloDatos.setTipoProveedor(null);
                this.modeloDatos.setDescripcionTipoProveedor("");
                this.compositeParteRelacionada.setVisible(true);
                this.cmbTipoProveedor.setVisible(false);
                this.lblTipoDeProveedor.setVisible(false);
            } else {
                this.lblTipoDeProveedor.setVisible(true);
                this.cmbTipoProveedor.setVisible(true);
            }
        }
    }

    private void renderizarParteRelacionadaParaAnexosEnRangoDe2013aMarzo2015(boolean esPasaporte) {
        if (this.periodo.isPeridoDeAnexoDesdeEnero2013aFebrero2015()) {
            if (!esPasaporte) {
                this.modeloDatos.setTipoProveedor(null);
                this.modeloDatos.setDescripcionTipoProveedor("");
                this.modeloDatos.setParteRelacionada(false);
            }
            this.cParteRelacionada.setVisible(esPasaporte);
        }
    }

    private void renderizarRazonSocialParaAnexosDesdeMayo2016(boolean esPasaporte) {
        if (this.periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            this.txtRazonSocial.setVisible(esPasaporte);
            this.lblRazonSocial.setVisible(esPasaporte);
            if (!esPasaporte) {
                this.txtRazonSocial.setText("");
            }
        }
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoIdProveedor.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvTipoIdProveedor.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tiposIdentificacionModeloValoresObserveList = PojoProperties.list((String)"tiposIdentificacion").observe((Object)this.modeloValores);
        this.cvTipoIdProveedor.setInput((Object)tiposIdentificacionModeloValoresObserveList);
        ISWTObservableValue observeTextTxtIdProveedorObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtIdProveedor);
        IObservableValue identificacionModeloDatosObserveValue = BeanProperties.value((String)"identificacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtIdProveedorObserveWidget, identificacionModeloDatosObserveValue, null, null);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap observeMap_1 = PojoObservables.observeMap((IObservableSet)listContentProvider_1.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoProveedor.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_1));
        this.cvTipoProveedor.setContentProvider((IContentProvider)listContentProvider_1);
        IObservableList tiposProveedorModeloValoresObserveList = PojoProperties.list((String)"tiposProveedor").observe((Object)this.modeloValores);
        this.cvTipoProveedor.setInput((Object)tiposProveedorModeloValoresObserveList);
        ISWTObservableValue observeSelectionButtonObserveWidget = WidgetProperties.selection().observe((Widget)this.btnSi);
        IObservableValue parteRelacionadaModeloDatosObserveValue = BeanProperties.value((String)"parteRelacionada").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeSelectionButtonObserveWidget, parteRelacionadaModeloDatosObserveValue, null, null);
        ISWTObservableValue observeSelectionButton_1ObserveWidget = WidgetProperties.selection().observe((Widget)this.btnNo);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
        strategy_1.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)observeSelectionButton_1ObserveWidget, parteRelacionadaModeloDatosObserveValue, strategy, strategy_1);
        ISWTObservableValue cParteRelacionadaObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.cParteRelacionada);
        IObservableValue periodoPeridoDeAnexoDesdeEnero2013aFebrero2015ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"peridoDeAnexoDesdeEnero2013aFebrero2015");
        bindingContext.bindValue((IObservableValue)cParteRelacionadaObserveVisibleObserveWidget, periodoPeridoDeAnexoDesdeEnero2013aFebrero2015ObserveValue, null, null);
        ISWTObservableValue txtRazonSocialObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtRazonSocial, (int)24);
        IObservableValue modeloDatosRazonSocialObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"razonSocial");
        bindingContext.bindValue((IObservableValue)txtRazonSocialObserveTextObserveWidget, modeloDatosRazonSocialObserveValue, null, null);
        ISWTObservableValue txtRazonSocialObserveVisibleObserveWidget_1 = SWTObservables.observeVisible((Control)this.txtRazonSocial);
        IObservableValue periodoAnexoEnPeriodoDesdeMayo2016ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"anexoEnPeriodoDesdeMayo2016");
        bindingContext.bindValue((IObservableValue)txtRazonSocialObserveVisibleObserveWidget_1, periodoAnexoEnPeriodoDesdeMayo2016ObserveValue, null, null);
        ISWTObservableValue lblRaznSocialObserveVisibleObserveWidget_1 = SWTObservables.observeVisible((Control)this.lblRazonSocial);
        bindingContext.bindValue((IObservableValue)lblRaznSocialObserveVisibleObserveWidget_1, periodoAnexoEnPeriodoDesdeMayo2016ObserveValue, null, null);
        return bindingContext;
    }
}

